
<?php
// Enable debug mode
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'config.php';
?>

<html>
<head>
    <link rel="icon" href="favicon.ico" type="image/x-icon" />
    <title>AI Receptionist : Subscription</title>
    <link rel='stylesheet' href='css/style.css' type='text/css' media='all' />
    <link href="css/bootstrap.min.css" rel="stylesheet">
</head>

<body>
<div class="container">
    <div class="row" style="margin-top:10%">
        <div class="col-md-3"></div>
        <div class="col-md-6">
            <div class="card shadow">
                <div class="text-uppercase text-center header-top shadow">
                    <h5 class="">AI Receptionist Signup</h5>
                </div>

                <div id="signup-message" class="p-4 hidden mt-2 ms-4 me-4"></div>

                <form id="ai-signup-form" class="p-4">
                    <div class="form-group mt-3">
                        <label><strong>Full Name</strong></label>
                        <input type="text" id="fullname" class="form-control" maxlength="50" required autofocus>
                    </div>
                    <div class="form-group">
                        <label><strong>Email</strong></label>
                        <input type="email" id="email" class="form-control" maxlength="50" required>
                    </div>
                    <button type="submit" class="pay">
                        <div class="spinner hidden" id="spinner"></div>
                        <span id="submit-text">Start Subscription</span>
                    </button>
                </form>

                <div id="payment_processing" class="hidden text-center p-4">
                    <span class="loader"></span> Please wait! Redirecting to Stripe...
                </div>

                <div id="payment-reinitiate" class="hidden p-4 text-center">
                    <button class="reinitiate_payment" onclick="window.location.reload()">
                        <span>Retry Signup</span>
                    </button>
                </div>
            </div>
        </div>
        <div class="col-md-3"></div>
    </div>
</div>

<script src="https://js.stripe.com/v3/"></script>
<script>
document.getElementById("ai-signup-form").addEventListener("submit", function (e) {
    e.preventDefault();

    const fullname = document.getElementById("fullname").value.trim();
    const email = document.getElementById("email").value.trim();

    document.getElementById("ai-signup-form").classList.add("hidden");
    document.getElementById("payment_processing").classList.remove("hidden");

    fetch("signup.php", {
        method: "POST",
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify({ fullname, email })
    })
    .then(response => response.json())
    .then(data => {
        if (data.checkout_url) {
            window.location.href = data.checkout_url;
        } else {
            throw new Error(data.error || 'Something went wrong');
        }
    })
    .catch(error => {
        document.getElementById("payment_processing").classList.add("hidden");
        document.getElementById("payment-reinitiate").classList.remove("hidden");
        document.getElementById("signup-message").classList.remove("hidden");
        document.getElementById("signup-message").innerText = "❌ " + error.message;
    });
});
</script>
<script src="js/bootstrap.bundle.min.js"></script>
</body>
</html>
