<?php
session_start();
require 'config.php';
require 'vendor/autoload.php';

\Stripe\Stripe::setApiKey(getenv('STRIPE_SECRET_KEY')); // or use your hardcoded key for testing

if (!isset($_GET['session_id'])) {
    die("❌ No session ID provided.");
}

$session_id = $_GET['session_id'];

try {
    // 1. Retrieve the checkout session
    $checkoutSession = \Stripe\Checkout\Session::retrieve($session_id);

    // 2. Get subscription and customer details
    $subscription = \Stripe\Subscription::retrieve($checkoutSession->subscription);
    $customer = \Stripe\Customer::retrieve($checkoutSession->customer);

    // 3. Extract values
    $stripeCustomerId = $customer->id;
    $stripeSubscriptionId = $subscription->id;
    $subscriptionStart = date('Y-m-d H:i:s', $subscription->current_period_start);
    $subscriptionEnd = date('Y-m-d H:i:s', $subscription->current_period_end);

    // 4. Get subscription_item_id (used for metered billing)
    $subscriptionItemId = $subscription->items->data[0]->id;

    // 5. Update the database
    $stmt = $pdo->prepare("
        UPDATE assistants SET
            stripe_customer_id = ?,
            stripe_subscription_id = ?,
            subscription_start = ?,
            subscription_end = ?,
            status = 'active',
            stripe_subscription_item_id = ?
        WHERE stripe_checkout_session_id = ?
    ");
    $stmt->execute([
        $stripeCustomerId,
        $stripeSubscriptionId,
        $subscriptionStart,
        $subscriptionEnd,
        $subscriptionItemId,
        $session_id
    ]);

    $_SESSION['message'] = "✅ Subscription activated successfully.";
    header('Location: dashboard.php'); // or wherever you want to redirect
    exit();

} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage();
    // Optionally log the error
}
