<?php
require 'stripe_header.php'; // Includes Stripe and DB config

// Enable error reporting for development
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Log helper
function log_debug($message) {
    file_put_contents('stripe_debug.log', date('Y-m-d H:i:s') . ' - ' . $message . PHP_EOL, FILE_APPEND);
}

try {
    $rawData = file_get_contents("php://input");
    log_debug("Raw input: $rawData");

    $data = json_decode($rawData);
    if (!$data) {
        throw new Exception("Invalid JSON input");
    }

    $fullname = trim($data->fullname ?? '');
    $email = trim($data->email ?? '');

    if (!$fullname || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        throw new Exception("Missing or invalid fullname/email");
    }

    // 1. Create Stripe customer
    $customer = \Stripe\Customer::create([
        'name' => $fullname,
        'email' => $email
    ]);
    log_debug("Customer created: " . $customer->id);

    // 2. Create Checkout Session
    $checkoutSession = \Stripe\Checkout\Session::create([
        'customer' => $customer->id,
        'payment_method_types' => ['card'],
        'mode' => 'subscription',
        'line_items' => [
            [
                'price' => 'price_SETUPFEE_ID', // Replace this
                'quantity' => 1,
            ],
            [
                'price' => 'price_SUBSCRIPTION_ID', // Replace this
                'quantity' => 1,
            ]
        ],
        'success_url' => 'https://yourdomain.com/success?session_id={CHECKOUT_SESSION_ID}',
        'cancel_url' => 'https://yourdomain.com/cancel',
    ]);
    log_debug("Checkout session created: " . $checkoutSession->id);

    // 3. Insert into database
    $stmt = $pdo->prepare("
        INSERT INTO assistants (
            email,
            company_name,
            status,
            stripe_checkout_session_id,
            stripe_price_id,
            stripe_customer_id
        ) VALUES (?, ?, 'pending', ?, ?, ?)
    ");
    $stmt->execute([
        $email,
        $fullname,
        $checkoutSession->id,
        'price_SUBSCRIPTION_ID', // Match price ID
        $customer->id
    ]);
    log_debug("Assistant inserted to DB");

    echo json_encode(['checkout_url' => $checkoutSession->url]);

} catch (Exception $e) {
    log_debug("❌ Error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
?>
